<?php
    // Default level to 'info' if not provided
    $level = $level ?? 'default';
    
    if ($level === 'success') {
        $bgColor = '#ECFDF5';
        $borderColor = '#10B981';
        $textColor = '#065F46';
    } elseif ($level === 'error') {
        $bgColor = '#FEF2F2';
        $borderColor = '#EF4444';
        $textColor = '#991B1B';
    } else {
        $bgColor = '#EFF6FF';
        $borderColor = '#3B82F6';
        $textColor = '#1E40AF';
    }
?>

<?php $__env->startComponent('mail::layout'); ?>

<?php $__env->slot('header'); ?>
<?php $__env->startComponent('mail::header', ['url' => config('app.url')]); ?>
<?php echo e($header ?? config('app.name')); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>


<?php echo e($slot); ?>



<?php if(isset($message) && $level != 'default'): ?>
<div class="info-box">
    <p><?php echo e($message); ?></p>
</div>
<?php endif; ?>


<?php if(isset($subcopy)): ?>
<?php $__env->slot('subcopy'); ?>
<?php $__env->startComponent('mail::subcopy'); ?>
<?php echo e($subcopy); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php endif; ?>


<?php $__env->slot('footer'); ?>
<?php $__env->startComponent('mail::footer'); ?>
© <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. <?php echo app('translator')->get('All rights reserved.'); ?>
<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/luxehave/trade.luxehavenhotel.com/resources/views/vendor/mail/html/message.blade.php ENDPATH**/ ?>