<div>
    <?php if(count($plans) > 0): ?>
        <div class="space-y-6">
            <!-- Plan Selection Area -->
            <div class="space-y-5">
                <!-- Plan Selection Tabs -->
                <div class="flex overflow-x-auto hide-scrollbar pb-2" x-data="{ activePlan: '<?php echo e($planSelected ? $planSelected->id : 0); ?>' }">
                    <div class="flex flex-col space-y-2 sm:flex-row sm:space-y-0 sm:space-x-2">
                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button 
                                wire:click="selectPlan(<?php echo e($plan->id); ?>)"
                                @click="activePlan = '<?php echo e($plan->id); ?>'"
                                class="flex-shrink-0 group relative px-4 py-3 rounded-xl transition-all duration-200 focus:outline-none"
                                :class="activePlan == '<?php echo e($plan->id); ?>' ? 'bg-primary text-white' : 'hover:bg-light-100 dark:hover:bg-dark-100 text-gray-700 dark:text-gray-300'"
                            >
                                <div class="flex items-center gap-3">
                                    <div class="flex items-center justify-center w-10 h-10 rounded-full" 
                                        :class="activePlan == '<?php echo e($plan->id); ?>' ? 'bg-white/20' : 'bg-primary/10 text-primary'">
                                        <i class="fas fa-chart-line"></i>
                                    </div>
                                    <div class="text-left">
                                        <p class="font-medium text-sm"><?php echo e($plan->name); ?></p>
                                        <p class="text-xs opacity-80"><?php echo e($settings->currency); ?><?php echo e(number_format($plan->min_price)); ?>+</p>
                                    </div>
                                </div>
                                <!-- Selected indicator dot -->
                                <div class="absolute -bottom-0.5 left-1/2 transform -translate-x-1/2 w-1.5 h-1.5 rounded-full transition-all duration-200"
                                    :class="activePlan == '<?php echo e($plan->id); ?>' ? 'bg-white' : 'bg-transparent'"></div>
                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Plan Details Card -->
                <?php if($planSelected): ?>
                <div class="rounded-xl overflow-hidden border border-light-200/50 dark:border-dark-200/50 bg-gradient-to-br from-white/50 to-white/20 dark:from-dark-50/50 dark:to-dark-50/20 p-5">
                    <div class="flex flex-col md:flex-row md:justify-between md:items-center gap-4">
                        <div>
                            <h3 class="font-semibold text-xl dark:text-white text-dark"><?php echo e($planSelected->name); ?></h3>
                            <p class="text-sm dark:text-gray-400 text-gray-600 mt-1">
                                <?php echo e($planSelected->expiration); ?> plan with 
                                <?php if($planSelected->increment_type == 'Fixed'): ?>
                                    <?php echo e($settings->currency); ?><?php echo e($planSelected->increment_amount); ?> <?php echo e($planSelected->increment_interval); ?>

                                <?php else: ?>
                                    <?php echo e($planSelected->increment_amount); ?>% <?php echo e($planSelected->increment_interval); ?>

                                <?php endif; ?>
                                returns
                            </p>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <div class="rounded-lg px-3 py-1.5 bg-primary/10 text-primary text-xs font-medium">
                                Min: <?php echo e($settings->currency); ?><?php echo e(number_format($planSelected->min_price)); ?>

                            </div>
                            <div class="rounded-lg px-3 py-1.5 bg-primary/10 text-primary text-xs font-medium">
                                Max: <?php echo e($settings->currency); ?><?php echo e(number_format($planSelected->max_price)); ?>

                            </div>
                            <div class="rounded-lg px-3 py-1.5 bg-green-500/10 text-green-500 text-xs font-medium">
                                <?php echo e($planSelected->minr); ?>% - <?php echo e($planSelected->maxr); ?>% ROI
                            </div>
                        </div>
                    </div>

                    <!-- Plan Benefits -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-5">
                        <div class="flex items-center gap-3">
                            <div class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-100 dark:bg-blue-900/30 flex items-center justify-center">
                                <i class="fas fa-calendar text-blue-600 dark:text-blue-400"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500">Duration</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected->expiration); ?></p>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="flex-shrink-0 w-8 h-8 rounded-full bg-green-100 dark:bg-green-900/30 flex items-center justify-center">
                                <i class="fas fa-chart-bar text-green-600 dark:text-green-400"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500">Return Rate</p>
                                <p class="text-sm font-medium dark:text-white text-dark">
                                    <?php if($planSelected->increment_type == 'Fixed'): ?>
                                        <?php echo e($settings->currency); ?><?php echo e($planSelected->increment_amount); ?> <?php echo e($planSelected->increment_interval); ?>

                                    <?php else: ?>
                                        <?php echo e($planSelected->increment_amount); ?>% <?php echo e($planSelected->increment_interval); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="flex-shrink-0 w-8 h-8 rounded-full bg-purple-100 dark:bg-purple-900/30 flex items-center justify-center">
                                <i class="fas fa-gift text-purple-600 dark:text-purple-400"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500">Bonus</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($settings->currency); ?><?php echo e($planSelected->gift); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>

            <!-- Investment Configuration -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Amount Selection Column -->
                <div class="space-y-6">
                    <!-- Quick Amount Selection -->
                    <div>
                        <p class="text-sm font-medium dark:text-white text-dark mb-3">
                            Quick Amount Selection
                        </p>
                        <div class="grid grid-cols-3 gap-2">
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('100')"><?php echo e($settings->currency); ?>100</button>
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('250')"><?php echo e($settings->currency); ?>250</button>
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('500')"><?php echo e($settings->currency); ?>500</button>
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('1000')"><?php echo e($settings->currency); ?>1K</button>
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('2000')"><?php echo e($settings->currency); ?>2K</button>
                            <button class="py-3 rounded-xl text-center transition-all duration-200 hover:scale-105 hover:shadow-md dark:text-white text-dark
                                        border border-light-200/50 dark:border-dark-200/50 hover:border-primary dark:hover:border-primary"
                                wire:click="selectAmount('5000')"><?php echo e($settings->currency); ?>5K</button>
                        </div>
                    </div>

                    <!-- Custom Amount Input -->
                    <div>
                        <p class="text-sm font-medium dark:text-white text-dark mb-3">
                            Or Enter Custom Amount
                        </p>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <span class="text-gray-500 dark:text-gray-400 text-lg font-medium"><?php echo e($settings->currency); ?></span>
                            </div>
                            <input 
                                type="number" 
                                required 
                                wire:model='amountToInvest'
                                wire:keyup="checkIfAmountIsEmpty" 
                                class="block w-full pl-10 pr-4 py-4 text-lg font-medium rounded-xl bg-light-100/50 dark:bg-dark-100/50 border border-light-200/50 dark:border-dark-200/50 focus:ring-2 focus:ring-primary focus:border-transparent dark:text-white text-dark transition-all duration-200" 
                                placeholder="Enter amount"
                                min="<?php echo e($planSelected ? $planSelected->min_price : '0'); ?>"
                                max="<?php echo e($planSelected ? $planSelected->max_price : '10000000000'); ?>"
                            >
                        </div>
                        
                        <!-- Min/Max Slider (if plan selected) -->
                        <?php if($planSelected && $planSelected->min_price < $planSelected->max_price): ?>
                        <div class="mt-3">
                            <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400 mb-1">
                                <span><?php echo e($settings->currency); ?><?php echo e(number_format($planSelected->min_price)); ?></span>
                                <span><?php echo e($settings->currency); ?><?php echo e(number_format($planSelected->max_price)); ?></span>
                            </div>
                            <div class="w-full h-1 bg-gray-200 dark:bg-dark-200 rounded-full overflow-hidden">
                                <?php if($amountToInvest > 0 && $planSelected->max_price > 0): ?>
                                    <?php
                                        $percentage = min(100, max(0, ($amountToInvest / $planSelected->max_price) * 100));
                                    ?>
                                    <div class="h-full bg-primary rounded-full" style="width: <?php echo e($percentage); ?>%"></div>
                                <?php else: ?>
                                    <div class="h-full bg-primary rounded-full" style="width: 0%"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Expected Returns Preview (if amount and plan selected) -->
                    <?php if($planSelected && $amountToInvest > 0): ?>
                    <div class="rounded-xl overflow-hidden border border-light-200/50 dark:border-dark-200/50 bg-light-100/50 dark:bg-dark-100/50 p-4">
                        <p class="text-sm font-medium dark:text-white text-dark mb-3">
                            Estimated Returns
                        </p>
                        
                        <div class="space-y-2">
                            <?php
                                // Calculate estimated returns based on plan type and duration
                                $duration = trim(preg_replace('/[^0-9]/', '', $planSelected->expiration));
                                $durationUnit = strpos(strtolower($planSelected->expiration), 'day') !== false ? 'days' : 
                                               (strpos(strtolower($planSelected->expiration), 'week') !== false ? 'weeks' : 
                                               (strpos(strtolower($planSelected->expiration), 'month') !== false ? 'months' : 'years'));
                                
                                // Calculate total return percentage based on min and max returns
                                $avgReturnPercentage = ($planSelected->minr + $planSelected->maxr) / 2;
                                $totalReturn = $amountToInvest * ($avgReturnPercentage / 100);
                                
                                // Calculate total profit (return + bonus)
                                $totalProfit = $totalReturn + $planSelected->gift;
                                
                                // Calculate final amount
                                $finalAmount = $amountToInvest + $totalProfit;
                            ?>
                            
                            <div class="flex justify-between items-center text-sm">
                                <span class="dark:text-gray-400 text-gray-600">Initial Investment:</span>
                                <span class="font-medium dark:text-white text-dark"><?php echo e($settings->currency); ?><?php echo e(number_format($amountToInvest, 2)); ?></span>
                            </div>
                            
                            <div class="flex justify-between items-center text-sm">
                                <span class="dark:text-gray-400 text-gray-600">Est. Return (<?php echo e($avgReturnPercentage); ?>%):</span>
                                <span class="font-medium text-green-500">+<?php echo e($settings->currency); ?><?php echo e(number_format($totalReturn, 2)); ?></span>
                            </div>
                            
                            <div class="flex justify-between items-center text-sm">
                                <span class="dark:text-gray-400 text-gray-600">Bonus:</span>
                                <span class="font-medium text-green-500">+<?php echo e($settings->currency); ?><?php echo e(number_format($planSelected->gift, 2)); ?></span>
                            </div>
                            
                            <div class="mt-3 pt-3 border-t border-light-200/50 dark:border-dark-200/50">
                                <div class="flex justify-between items-center">
                                    <span class="font-medium dark:text-white text-dark">Total Value:</span>
                                    <span class="font-bold text-lg text-primary"><?php echo e($settings->currency); ?><?php echo e(number_format($finalAmount, 2)); ?></span>
                                </div>
                                <div class="text-xs text-center dark:text-gray-400 text-gray-600 mt-1">
                                    After <?php echo e($duration); ?> <?php echo e($durationUnit); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Payment Method Column -->
                <div class="space-y-6">
                    <!-- Payment Method Selection -->
                    <div>
                        <p class="text-sm font-medium dark:text-white text-dark mb-3">
                            Payment Method
                        </p>
                        
                        <div class="space-y-3">
                            <!-- Account Balance Option -->
                            <div 
                                class="relative rounded-xl overflow-hidden border-2 transition-all duration-200 cursor-pointer <?php echo e($paymentMethod == 'Account Balance' ? 'border-primary dark:border-primary shadow-lg shadow-primary/10' : 'border-light-200/50 dark:border-dark-200/50 hover:border-primary/50 dark:hover:border-primary/50'); ?>"
                                wire:click="chanegePaymentMethod('Account Balance')"
                            >
                                <div class="flex items-center gap-4 p-4">
                                    <div class="flex-shrink-0 w-12 h-12 rounded-xl <?php echo e($paymentMethod == 'Account Balance' ? 'bg-primary text-white' : 'bg-primary/10 text-primary'); ?> flex items-center justify-center">
                                        <i class="fas fa-wallet"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium dark:text-white text-dark">Account Balance</p>
                                        <p class="text-sm dark:text-gray-400 text-gray-600">
                                            <?php echo e($settings->currency); ?><?php echo e(number_format(Auth::user()->account_bal, 2)); ?> available
                                        </p>
                                    </div>
                                    <?php if($paymentMethod == 'Account Balance'): ?>
                                        <div class="absolute right-3 top-3">
                                            <div class="w-6 h-6 rounded-full bg-primary flex items-center justify-center text-white">
                                                <i class="fas fa-check"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Available Balance Progress Bar -->
                                <div class="px-4 pb-4">
                                    <?php if(Auth::user()->account_bal > 0 && $amountToInvest > 0): ?>
                                        <?php
                                            $balancePercentage = min(100, max(0, ($amountToInvest / Auth::user()->account_bal) * 100));
                                        ?>
                                        <div class="w-full h-1.5 bg-gray-200 dark:bg-dark-200 rounded-full overflow-hidden">
                                            <div class="h-full <?php echo e($balancePercentage > 90 ? 'bg-red-500' : 'bg-green-500'); ?> rounded-full" style="width: <?php echo e($balancePercentage); ?>%"></div>
                                        </div>
                                        <div class="flex justify-end">
                                            <span class="text-xs mt-1 <?php echo e($balancePercentage > 90 ? 'text-red-500' : 'text-green-500'); ?>">
                                                <?php echo e($balancePercentage); ?>% of balance
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                     <!-- Alerts -->
                <div>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                </div>
                    
                    <!-- Investment Summary -->
                    <div class="rounded-xl overflow-hidden border border-light-200/50 dark:border-dark-200/50 bg-light-100/50 dark:bg-dark-100/50">
                        <div class="p-4 border-b border-light-200/50 dark:border-dark-200/50">
                            <p class="font-medium dark:text-white text-dark">Investment Summary</p>
                        </div>
                        <div class="p-4">
                            <div class="space-y-3">
                                <div class="flex justify-between items-center">
                                    <span class="text-sm dark:text-gray-400 text-gray-600">Selected Plan:</span>
                                    <span class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->name : '-'); ?></span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-sm dark:text-gray-400 text-gray-600">Investment Amount:</span>
                                    <span class="text-sm font-medium dark:text-white text-dark"><?php echo e($settings->currency); ?><?php echo e($amountToInvest ? number_format($amountToInvest, 2) : '0.00'); ?></span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-sm dark:text-gray-400 text-gray-600">Payment Method:</span>
                                    <span class="text-sm font-medium dark:text-white text-dark"><?php echo e($paymentMethod ? $paymentMethod : '-'); ?></span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-sm dark:text-gray-400 text-gray-600">Duration:</span>
                                    <span class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->expiration : '-'); ?></span>
                                </div>
                            </div>
                            
                            
                            <!-- Invest Button -->
                            <div class="mt-4">
                                <form action="" wire:submit.prevent="joinPlan">
                                    <button 
                                        type="submit"
                                        class="w-full py-3 rounded-xl bg-gradient-to-r from-primary to-primary/90 text-white font-medium flex items-center justify-center gap-2 hover:shadow-lg hover:shadow-primary/20 transition-all duration-200 disabled:opacity-70 disabled:cursor-not-allowed"
                                        <?php echo e($disabled); ?>

                                    >
                                        <i class="fas fa-chart-line"></i>
                                        Confirm & Invest Now
                                    </button>
                                </form>
                                <p class="mt-2 text-sm text-center text-primary" wire:loading wire:target="joinPlan">
                                    <?php echo e($feedback); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- No Plans Available State -->
        <div class="rounded-xl overflow-hidden bg-gradient-to-br from-white/50 to-white/20 dark:from-dark-50/50 dark:to-dark-50/20 border border-light-200/50 dark:border-dark-200/50">
            <div class="p-8 text-center">
                <div class="w-20 h-20 rounded-full bg-yellow-100 dark:bg-yellow-900/30 flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-exclamation-circle fa-3x text-yellow-600 dark:text-yellow-400"></i>
                </div>
                <h3 class="text-xl font-semibold dark:text-white text-dark mb-2">No Investment Plans Available</h3>
                <p class="text-gray-600 dark:text-gray-400 max-w-md mx-auto mb-6">
                    We're currently updating our investment offerings to bring you better opportunities. Please check back soon or contact our support team for assistance.
                </p>
                <div class="flex flex-wrap gap-3 justify-center">
                    <button class="px-5 py-2.5 rounded-xl bg-primary text-white font-medium flex items-center gap-2 hover:bg-primary/90 transition-colors">
                        <i class="fas fa-comment"></i>
                        Contact Support
                    </button>
                    <button class="px-5 py-2.5 rounded-xl border border-light-200 dark:border-dark-200 dark:text-white text-dark font-medium flex items-center gap-2 hover:bg-light-100 dark:hover:bg-dark-100 transition-colors">
                        <i class="fas fa-sync-alt"></i>
                        Refresh Page
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH /home/karamelh/public_html/pecan.karamelscript.com.ng/resources/views/livewire/user/investment-plan.blade.php ENDPATH**/ ?>