
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>

<!-- Modern Page Header with Animation -->
<div class="relative mb-8 overflow-hidden rounded-xl">
    <!-- Animated Background with Gradient -->
    <div class="absolute inset-0 bg-gradient-to-r dark:from-primary/20 dark:via-secondary/10 dark:to-tertiary/20 from-primary/10 via-secondary/5 to-tertiary/10 opacity-70"></div>
    
    <!-- Subtle Pattern Overlay -->
    <div class="absolute inset-0 opacity-5">
        <svg width="100%" height="100%">
            <pattern id="depositPattern" width="40" height="40" patternUnits="userSpaceOnUse">
                <path d="M0 20 L40 20 M20 0 L20 40" stroke="currentColor" stroke-width="0.5" fill="none"></path>
            </pattern>
            <rect width="100%" height="100%" fill="url(#depositPattern)"></rect>
        </svg>
    </div>
    
    <!-- Floating Coins Animation (Pure CSS) -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="coin coin-1 dark:bg-primary/30 bg-primary/20"></div>
        <div class="coin coin-2 dark:bg-secondary/30 bg-secondary/20"></div>
        <div class="coin coin-3 dark:bg-tertiary/30 bg-tertiary/20"></div>
        <div class="coin coin-4 dark:bg-accent/30 bg-accent/20"></div>
    </div>
    
    <!-- Header Content -->
    <div class="relative z-10 p-8">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div class="mb-4 md:mb-0">
                <h1 class="text-2xl md:text-3xl font-bold dark:text-white text-dark mb-2">Fund Your Account</h1>
                <p class="text-sm md:text-base dark:text-gray-300 text-gray-700">Add funds to your account to start investing or trading</p>
            </div>
            <div class="flex items-center space-x-3">
                <div class="bg-gradient-to-r from-secondary to-secondary/70 text-white px-4 py-2 rounded-lg shadow-md">
                    <p class="text-xs uppercase font-semibold opacity-80">Current Balance</p>
                    <p class="text-lg font-bold"><?php echo e($settings->currency); ?><?php echo e(number_format(Auth::user()->account_bal, 2, '.', ',')); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<!-- Main Content Container -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Deposit Form Section (Spans 2 columns on large screens) -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Modern Card with Interactive Payment Methods -->
        <div class="dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-xl overflow-hidden shadow-lg">
            <div class="p-6">
                <form action="javascript:;" method="post" id="submitpaymentform" class="space-y-6">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Amount Input with Visual Feedback -->
                    <div class="space-y-2">
                        <label for="amount" class="block text-sm font-medium dark:text-gray-300 text-gray-700">Enter Amount</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 sm:text-sm"><?php echo e($settings->currency); ?></span>
                            </div>
                            <input type="number" name="amount" id="amount" min="<?php echo e($moresettings->minamt); ?>" 
                                   class="dark:bg-dark-100 bg-light-200 dark:text-white text-dark block w-full pl-12 pr-12 py-3 border-0 dark:border-dark-100 border-light-200 rounded-lg focus:ring-2 focus:ring-primary dark:focus:border-primary focus:border-primary transition-all duration-200" 
                                   placeholder="0.00" required>
                            <div class="absolute inset-y-0 right-0 flex items-center">
                                <label for="currency" class="sr-only">Currency</label>
                                <div class="px-3 dark:text-gray-400 text-gray-600 text-xs">
                                    Min: <?php echo e($settings->currency); ?><?php echo e($moresettings->minamt); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <input type="hidden" name="payment_method" id="paymethod">
                    
                    <!-- Payment Methods Section with Modern Cards -->
                    <div class="space-y-4">
                        <h3 class="text-lg font-medium dark:text-white text-dark">Select Payment Method</h3>
                        
                        <!-- Payment Methods Grid -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <?php $__empty_1 = true; $__currentLoopData = $dmethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="payment-method-card" data-method="<?php echo e($method->name); ?>" id="<?php echo e($method->id); ?>" onclick="checkpamethd(this.id)">
                                    <div class="dark:bg-dark-100 bg-light-200 dark:border-dark-100 border-light-200 border rounded-lg overflow-hidden transition-all duration-300 hover:shadow-md payment-card-inner">
                                        <div class="p-4 flex justify-between items-center">
                                            <div class="flex items-center space-x-3">
                                                <?php if(!empty($method->img_url)): ?>
                                                    <div class="flex-shrink-0 h-10 w-10 rounded-full overflow-hidden bg-white p-1 flex items-center justify-center">
                                                        <img src="<?php echo e($method->img_url); ?>" alt="<?php echo e($method->name); ?>" class="max-h-full">
                                                    </div>
                                                <?php else: ?>
                                                    <div class="flex-shrink-0 h-10 w-10 rounded-full bg-primary/10 flex items-center justify-center">
                                                        <i data-lucide="credit-card" class="h-5 w-5 text-primary"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($method->name); ?></p>
                                                    <p class="text-xs dark:text-gray-400 text-gray-600">Instant Processing</p>
                                                </div>
                                            </div>
                                            <div class="payment-radio">
                                                <div class="h-6 w-6 rounded-full border-2 dark:border-dark-300 border-light-300 flex items-center justify-center payment-radio-outer">
                                                    <div class="h-3 w-3 rounded-full bg-primary hidden payment-radio-inner"></div>
                                                </div>
                                            </div>
                                            <input type="radio" name="payment_option" id="<?php echo e($method->id); ?>customCheck1" class="hidden">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-span-2 dark:bg-dark-100 bg-light-200 p-6 rounded-lg text-center">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="rounded-full bg-primary/10 p-3 mb-4">
                                            <i data-lucide="alert-circle" class="h-6 w-6 text-primary"></i>
                                        </div>
                                        <h4 class="text-lg font-medium dark:text-white text-dark mb-2">No Payment Methods</h4>
                                        <p class="dark:text-gray-400 text-gray-600">No payment methods are enabled at the moment. Please check back later.</p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Submit Button (Conditionally Displayed) -->
                    <?php if(count($dmethods) > 0): ?>
                        <div class="pt-4">
                            <button type="submit" class="w-full py-3 px-4 bg-gradient-to-r from-primary to-primary/80 text-white font-medium rounded-lg shadow-lg hover:shadow-xl transform transition hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-primary/50">
                                <div class="flex items-center justify-center">
                                    <i data-lucide="arrow-right" class="h-5 w-5 mr-2"></i>
                                    <span>Proceed to Payment</span>
                                </div>
                            </button>
                        </div>
                        <input type="hidden" id="lastchosen" value="0">
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Right Sidebar with Stats and History -->
    <div class="space-y-6">
        <!-- Deposit Stats Card -->
        <div class="dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-xl overflow-hidden shadow-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium dark:text-white text-dark mb-4">Deposit Summary</h3>
                
                <!-- Total Deposit Stats -->
                <div class="dark:bg-dark-100 bg-light-200 rounded-lg p-4 mb-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm dark:text-gray-400 text-gray-600">Total Deposited</p>
                            <p class="text-2xl font-bold dark:text-white text-dark">
                                <?php echo e($settings->currency); ?><?php echo e(number_format($deposited, 2, '.', ',')); ?>

                            </p>
                        </div>
                        <div class="h-14 w-14 rounded-full bg-tertiary/10 flex items-center justify-center">
                            <i data-lucide="arrow-down" class="h-6 w-6 text-tertiary"></i>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Stats -->
                <div class="grid grid-cols-2 gap-4">
                    <div class="dark:bg-dark-100 bg-light-200 rounded-lg p-3">
                        <p class="text-xs dark:text-gray-400 text-gray-600 mb-1">Pending Deposits</p>
                        <p class="text-lg font-bold dark:text-white text-dark">0</p>
                    </div>
                    <div class="dark:bg-dark-100 bg-light-200 rounded-lg p-3">
                        <p class="text-xs dark:text-gray-400 text-gray-600 mb-1">Last Deposit</p>
                        <p class="text-lg font-bold dark:text-white text-dark">
                            <?php echo e(isset($last_deposit) ? $settings->currency . number_format($last_deposit->amount, 2, '.', ',') : '-'); ?>

                        </p>
                    </div>
                </div>
                
                <!-- History Link -->
                <div class="mt-6">
                    <a href="<?php echo e(route('accounthistory')); ?>" class="flex items-center justify-center py-2 px-4 dark:bg-dark-100 bg-light-200 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-300 transition-colors rounded-lg">
                        <i data-lucide="history" class="h-4 w-4 mr-2"></i>
                        <span>View Deposit History</span>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Security Notice Card -->
        <div class="dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-xl overflow-hidden shadow-lg">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="h-10 w-10 rounded-full bg-secondary/10 flex items-center justify-center mr-3">
                        <i data-lucide="shield" class="h-5 w-5 text-secondary"></i>
                    </div>
                    <h3 class="text-lg font-medium dark:text-white text-dark">Secure Payments</h3>
                </div>
                
                <ul class="space-y-3">
                    <li class="flex items-start">
                        <i data-lucide="check-circle" class="h-5 w-5 text-secondary mr-2 mt-0.5"></i>
                        <span class="text-sm dark:text-gray-300 text-gray-700">All payment methods are secured with encryption</span>
                    </li>
                    <li class="flex items-start">
                        <i data-lucide="check-circle" class="h-5 w-5 text-secondary mr-2 mt-0.5"></i>
                        <span class="text-sm dark:text-gray-300 text-gray-700">Funds are credited instantly to your account</span>
                    </li>
                    <li class="flex items-start">
                        <i data-lucide="check-circle" class="h-5 w-5 text-secondary mr-2 mt-0.5"></i>
                        <span class="text-sm dark:text-gray-300 text-gray-700">24/7 deposit monitoring and support</span>
                    </li>
                </ul>
                
                <div class="mt-4 pt-4 dark:border-dark-100 border-light-200 border-t">
                    <div class="flex items-center">
                        <i data-lucide="alert-circle" class="h-4 w-4 text-primary mr-2"></i>
                        <span class="text-xs dark:text-gray-400 text-gray-600">Need help? Contact our support team.</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add some interactive styles -->
<style>
    /* Animated coins */
    .coin {
        position: absolute;
        border-radius: 50%;
        opacity: 0.7;
        animation-duration: 15s;
        animation-iteration-count: infinite;
        animation-timing-function: linear;
    }
    
    .coin-1 {
        width: 80px;
        height: 80px;
        top: 10%;
        left: 5%;
        animation-name: floating1;
    }
    
    .coin-2 {
        width: 50px;
        height: 50px;
        top: 20%;
        right: 10%;
        animation-name: floating2;
    }
    
    .coin-3 {
        width: 40px;
        height: 40px;
        bottom: 20%;
        left: 15%;
        animation-name: floating3;
    }
    
    .coin-4 {
        width: 60px;
        height: 60px;
        bottom: 10%;
        right: 5%;
        animation-name: floating4;
    }
    
    @keyframes  floating1 {
        0% { transform: translate(0, 0) rotate(0deg); }
        25% { transform: translate(10px, 10px) rotate(90deg); }
        50% { transform: translate(0, 20px) rotate(180deg); }
        75% { transform: translate(-10px, 10px) rotate(270deg); }
        100% { transform: translate(0, 0) rotate(360deg); }
    }
    
    @keyframes  floating2 {
        0% { transform: translate(0, 0) rotate(0deg); }
        25% { transform: translate(-15px, 5px) rotate(-90deg); }
        50% { transform: translate(0, 10px) rotate(-180deg); }
        75% { transform: translate(15px, 5px) rotate(-270deg); }
        100% { transform: translate(0, 0) rotate(-360deg); }
    }
    
    @keyframes  floating3 {
        0% { transform: translate(0, 0) rotate(0deg); }
        33% { transform: translate(10px, -10px) rotate(120deg); }
        66% { transform: translate(-10px, -10px) rotate(240deg); }
        100% { transform: translate(0, 0) rotate(360deg); }
    }
    
    @keyframes  floating4 {
        0% { transform: translate(0, 0) rotate(0deg); }
        33% { transform: translate(-15px, -5px) rotate(-120deg); }
        66% { transform: translate(15px, -10px) rotate(-240deg); }
        100% { transform: translate(0, 0) rotate(-360deg); }
    }
    
    /* Payment methods card hover effects */
    .payment-method-card.active .payment-card-inner {
        border-color: theme('colors.primary.DEFAULT');
        box-shadow: 0 0 0 1px theme('colors.primary.DEFAULT');
    }
    
    .payment-method-card.active .payment-radio-inner {
        display: block;
    }
</style>

<!-- Add JavaScript to handle payment method selection -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Lucide icons
        lucide.createIcons();
        
        // Initialize payment method selection
        const paymentCards = document.querySelectorAll('.payment-method-card');
        
        paymentCards.forEach(card => {
            card.addEventListener('click', function() {
                // Remove active class from all cards
                paymentCards.forEach(c => c.classList.remove('active'));
                
                // Add active class to clicked card
                this.classList.add('active');
                
                // Update the hidden radio button
                const radioId = this.id + 'customCheck1';
                document.getElementById(radioId).checked = true;
            });
        });
    });
    
    // Function to handle payment method selection (from original script)
    function checkpamethd(id) {
        document.getElementById('paymethod').value = id;
        
        // Set the last chosen payment method
        document.getElementById('lastchosen').value = id;
        
        // Highlight the selected payment method
        const paymentCards = document.querySelectorAll('.payment-method-card');
        paymentCards.forEach(card => {
            if (card.id === id) {
                card.classList.add('active');
            } else {
                card.classList.remove('active');
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home7/ticketie/public_html/resources/views/user/deposits.blade.php ENDPATH**/ ?>