
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <!-- Page Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold dark:text-white text-dark">Investment Plans</h1>
        <p class="mt-1 text-sm dark:text-gray-400 text-gray-600">Choose the perfect investment strategy for your goals</p>
    </div>
    
    <!-- Investment Plans Container -->
    <div class="dark:bg-dark-50 bg-white rounded-xl shadow-lg overflow-hidden">
        <!-- Card Header -->
        <div class="dark:bg-dark-100/50 bg-light-100/50 px-6 py-4 border-b dark:border-dark-200/50 border-light-200/50">
            <div class="flex flex-wrap items-center justify-between">
                <h2 class="text-lg font-semibold dark:text-white text-dark flex items-center">
                    <i data-lucide="trending-up" class="h-5 w-5 mr-2 text-primary"></i>
                    Available Investment Plans
                </h2>
                
                <!-- Info Badge -->
                <div class="mt-2 sm:mt-0 inline-flex items-center px-3 py-1 rounded-full text-xs font-medium dark:bg-primary/10 bg-primary/10 dark:text-primary text-primary">
                    <i data-lucide="info" class="h-3 w-3 mr-1"></i>
                    <span>Select a plan to get started</span>
                </div>
            </div>
        </div>
        
        <!-- Card Body - LiveWire Component -->
        <div class="p-4 sm:p-6">
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.investment-plan', [])->html();
} elseif ($_instance->childHasBeenRendered('4Py5YNM')) {
    $componentId = $_instance->getRenderedChildComponentId('4Py5YNM');
    $componentTag = $_instance->getRenderedChildComponentTagName('4Py5YNM');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('4Py5YNM');
} else {
    $response = \Livewire\Livewire::mount('user.investment-plan', []);
    $html = $response->html();
    $_instance->logRenderedChild('4Py5YNM', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        </div>
    </div>
    
    <!-- Investment Guide -->
    <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Step 1 -->
        <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden">
            <div class="p-5">
                <div class="flex items-center justify-center h-12 w-12 rounded-full bg-primary/10 mb-4">
                    <i data-lucide="search" class="h-6 w-6 text-primary"></i>
                </div>
                <h3 class="font-medium dark:text-white text-dark text-lg mb-2">1. Choose a Plan</h3>
                <p class="dark:text-gray-400 text-gray-600 text-sm">
                    Browse our range of investment plans and select one that matches your financial goals.
                </p>
            </div>
        </div>
        
        <!-- Step 2 -->
        <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden">
            <div class="p-5">
                <div class="flex items-center justify-center h-12 w-12 rounded-full bg-secondary/10 mb-4">
                    <i data-lucide="credit-card" class="h-6 w-6 text-secondary"></i>
                </div>
                <h3 class="font-medium dark:text-white text-dark text-lg mb-2">2. Make a Deposit</h3>
                <p class="dark:text-gray-400 text-gray-600 text-sm">
                    Fund your investment with the desired amount using your preferred payment method.
                </p>
            </div>
        </div>
        
        <!-- Step 3 -->
        <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden">
            <div class="p-5">
                <div class="flex items-center justify-center h-12 w-12 rounded-full bg-tertiary/10 mb-4">
                    <i data-lucide="bar-chart-2" class="h-6 w-6 text-tertiary"></i>
                </div>
                <h3 class="font-medium dark:text-white text-dark text-lg mb-2">3. Watch It Grow</h3>
                <p class="dark:text-gray-400 text-gray-600 text-sm">
                    Monitor your investment growth and receive returns according to your selected plan.
                </p>
            </div>
        </div>
    </div>
    
    <!-- FAQ Section -->
    <div class="mt-6">
        <div class="dark:bg-dark-50 bg-white rounded-xl shadow-lg overflow-hidden">
            <!-- Card Header -->
            <div class="dark:bg-dark-100/50 bg-light-100/50 px-6 py-4 border-b dark:border-dark-200/50 border-light-200/50">
                <h2 class="text-lg font-semibold dark:text-white text-dark flex items-center">
                    <i data-lucide="help-circle" class="h-5 w-5 mr-2 text-primary"></i>
                    Frequently Asked Questions
                </h2>
            </div>
            
            <!-- FAQ Content -->
            <div class="p-4 sm:p-6 space-y-4">
                <!-- FAQ Item 1 -->
                <div x-data="{ open: false }" class="border dark:border-dark-100 border-light-200 rounded-lg overflow-hidden">
                    <button 
                        @click="open = !open" 
                        class="flex justify-between items-center w-full px-4 py-3 text-left dark:text-white text-dark font-medium hover:dark:bg-dark-100/50 hover:bg-light-100/50 focus:outline-none transition-colors"
                    >
                        <span>How do investment plans work?</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 dark:text-gray-400 text-gray-500 transition-transform duration-200" :class="{'transform rotate-180': open}"></i>
                    </button>
                    <div x-show="open" x-collapse>
                        <div class="px-4 pb-4 pt-0 dark:text-gray-300 text-gray-700 text-sm">
                            Our investment plans allow you to grow your capital by investing in various markets. Each plan has a specified duration and return rate. Once you select a plan and make a deposit, your returns will be calculated according to the plan's terms.
                        </div>
                    </div>
                </div>
                
                <!-- FAQ Item 2 -->
                <div x-data="{ open: false }" class="border dark:border-dark-100 border-light-200 rounded-lg overflow-hidden">
                    <button 
                        @click="open = !open" 
                        class="flex justify-between items-center w-full px-4 py-3 text-left dark:text-white text-dark font-medium hover:dark:bg-dark-100/50 hover:bg-light-100/50 focus:outline-none transition-colors"
                    >
                        <span>What is the minimum investment amount?</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 dark:text-gray-400 text-gray-500 transition-transform duration-200" :class="{'transform rotate-180': open}"></i>
                    </button>
                    <div x-show="open" x-collapse>
                        <div class="px-4 pb-4 pt-0 dark:text-gray-300 text-gray-700 text-sm">
                            The minimum investment amount varies by plan. You can find the specific minimum deposit requirements listed with each investment plan. We offer options for various budget levels.
                        </div>
                    </div>
                </div>
                
                <!-- FAQ Item 3 -->
                <div x-data="{ open: false }" class="border dark:border-dark-100 border-light-200 rounded-lg overflow-hidden">
                    <button 
                        @click="open = !open" 
                        class="flex justify-between items-center w-full px-4 py-3 text-left dark:text-white text-dark font-medium hover:dark:bg-dark-100/50 hover:bg-light-100/50 focus:outline-none transition-colors"
                    >
                        <span>How and when will I receive my returns?</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 dark:text-gray-400 text-gray-500 transition-transform duration-200" :class="{'transform rotate-180': open}"></i>
                    </button>
                    <div x-show="open" x-collapse>
                        <div class="px-4 pb-4 pt-0 dark:text-gray-300 text-gray-700 text-sm">
                            Returns are credited to your account according to the plan's payment schedule. Some plans provide daily returns, while others may pay weekly or at the end of the investment term. You can withdraw your earnings to your preferred payment method at any time.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home7/ticketie/public_html/resources/views/user/mplans.blade.php ENDPATH**/ ?>