<div>
    <?php if(count($plans) > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="md:col-span-2">
                <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden">
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                    <div class="p-5">
                        <!-- Plan Selection Dropdown -->
                        <div class="relative" x-data="{ open: false }" @click.away="open = false">
                            <button 
                                @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg border dark:border-dark-200 border-light-200 dark:text-white text-dark focus:outline-none"
                            >
                                <div class="flex items-center">
                                    <?php if($planSelected): ?>
                                        <i data-lucide="seedling" class="h-5 w-5 mr-2 text-primary"></i>
                                        <span><?php echo e($planSelected->name); ?></span>
                                    <?php else: ?>
                                        <span>Select your plan</span>
                                    <?php endif; ?>
                                </div>
                                <i data-lucide="chevron-down" class="h-5 w-5 transition-transform duration-200" :class="{'transform rotate-180': open}"></i>
                            </button>
                            
                            <div 
                                x-show="open" 
                                x-transition:enter="transition ease-out duration-100"
                                x-transition:enter-start="transform opacity-0 scale-95"
                                x-transition:enter-end="transform opacity-100 scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="transform opacity-100 scale-100"
                                x-transition:leave-end="transform opacity-0 scale-95"
                                class="absolute z-10 mt-1 w-full rounded-lg shadow-lg dark:bg-dark-50 bg-white border dark:border-dark-200 border-light-200 overflow-hidden"
                            >
                                <ul class="max-h-60 overflow-auto py-1">
                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="cursor-pointer px-4 py-2 hover:dark:bg-dark-100 hover:bg-light-100 dark:text-white text-dark flex items-center" 
                                            wire:click="selectPlan(<?php echo e($plan->id); ?>)"
                                            @click="open = false"
                                        >
                                            <i data-lucide="seedling" class="h-5 w-5 mr-2 text-primary"></i>
                                            <span><?php echo e($plan->name); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        <!-- Quick Amount Selection -->
                        <div class="mt-6">
                            <p class="text-sm font-medium dark:text-gray-300 text-gray-700 mb-3">Choose Quick Amount to Invest</p>
                            <div class="flex flex-wrap gap-2">
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('100')"><?php echo e($settings->currency); ?>100</button>
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('250')"><?php echo e($settings->currency); ?>250</button>
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('500')"><?php echo e($settings->currency); ?>500</button>
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('1000')"><?php echo e($settings->currency); ?>1,000</button>
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('1500')"><?php echo e($settings->currency); ?>1,500</button>
                                <button class="px-4 py-2 rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:hover:bg-dark-200 hover:bg-light-200 transition-colors"
                                    wire:click="selectAmount('2000')"><?php echo e($settings->currency); ?>2,000</button>
                            </div>
                        </div>

                        <!-- Custom Amount Input -->
                        <div class="mt-6">
                            <p class="text-sm font-medium dark:text-gray-300 text-gray-700 mb-3">Or Enter Your Amount</p>
                            <div class="relative rounded-lg">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 sm:text-sm"><?php echo e($settings->currency); ?></span>
                                </div>
                                <input 
                                    type="number" 
                                    required 
                                    wire:model='amountToInvest'
                                    wire:keyup="checkIfAmountIsEmpty" 
                                    class="block w-full pl-10 pr-12 py-3 sm:text-sm rounded-lg dark:bg-dark-100 bg-light-100 dark:text-white text-dark dark:border-dark-200 border-light-200 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition" 
                                    placeholder="1000"
                                    min="<?php echo e($planSelected ? $planSelected->min_price : '0'); ?>"
                                    max="<?php echo e($planSelected ? $planSelected->max_price : '10000000000'); ?>"
                                >
                            </div>
                        </div>

                        <!-- Payment Method Selection -->
                        <div class="mt-6">
                            <p class="text-sm font-medium dark:text-gray-300 text-gray-700 mb-3">Choose Payment Method</p>
                            <div class="space-y-3">
                                <div 
                                    class="rounded-lg p-4 cursor-pointer transition-all <?php echo e($paymentMethod == 'Account Balance' ? 'dark:bg-primary/10 bg-primary/10 dark:border-primary border-primary' : 'dark:bg-dark-100 bg-light-100 dark:border-dark-200 border-light-200'); ?> border-2" 
                                    wire:click="chanegePaymentMethod('Account Balance')"
                                >
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center">
                                            <div class="flex items-center justify-center h-10 w-10 rounded-full dark:bg-primary/10 bg-primary/10 dark:text-primary text-primary mr-3">
                                                <i data-lucide="wallet" class="h-5 w-5"></i>
                                            </div>
                                            <div>
                                                <p class="font-medium dark:text-white text-dark">Account Balance</p>
                                                <p class="text-sm dark:text-gray-400 text-gray-600">
                                                    <?php echo e($settings->currency); ?><?php echo e(number_format(Auth::user()->account_bal)); ?>

                                                </p>
                                            </div>
                                        </div>
                                        <?php if($paymentMethod == 'Account Balance'): ?>
                                            <div class="text-primary">
                                                <i data-lucide="check-circle" class="h-5 w-5"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Investment Details Summary Card -->
            <div class="md:col-span-1">
                <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden sticky top-4">
                    <div class="dark:bg-dark-100/50 bg-light-100/50 px-4 py-3 border-b dark:border-dark-200/50 border-light-200/50">
                        <h3 class="font-medium text-base dark:text-white text-dark flex items-center">
                            <i data-lucide="clipboard-list" class="h-4 w-4 mr-2 text-primary"></i>
                            Your Investment Details
                        </h3>
                    </div>
                    <div class="p-4">
                        <div class="grid grid-cols-2 gap-3">
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Name of plan</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->name : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Plan Price</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($settings->currency); ?><?php echo e($planSelected ? $planSelected->price : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Duration</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->expiration : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Profit</p>
                                <p class="text-sm font-medium dark:text-white text-dark">
                                    <?php if($planSelected): ?>
                                        <?php if($planSelected->increment_type == 'Fixed'): ?>
                                            <?php echo e($settings->currency); ?><?php echo e($planSelected->increment_amount); ?>

                                            <?php echo e($planSelected->increment_interval); ?>

                                        <?php else: ?>
                                            <?php echo e($planSelected->increment_amount); ?>%
                                            <?php echo e($planSelected->increment_interval); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Minimum Deposit</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $settings->currency . $planSelected->min_price : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Maximum Deposit</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $settings->currency . $planSelected->max_price : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Minimum Return</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->minr . '%' : '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Maximum Return</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $planSelected->maxr . '%' : '-'); ?></p>
                            </div>
                            <div class="col-span-2">
                                <p class="text-xs dark:text-gray-400 text-gray-500 mb-1">Bonus</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($planSelected ? $settings->currency . $planSelected->gift : '-'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Payment Method and Amount Summary -->
                        <div class="mt-4 pt-4 border-t dark:border-dark-200 border-light-200">
                            <div class="flex justify-between mb-2">
                                <p class="text-sm dark:text-gray-300 text-gray-700">Payment method:</p>
                                <p class="text-sm font-medium dark:text-white text-dark"><?php echo e($paymentMethod ? $paymentMethod : '-'); ?></p>
                            </div>
                            <div class="flex justify-between mb-4">
                                <p class="text-base font-medium dark:text-white text-dark">Amount to Invest:</p>
                                <p class="text-base font-medium text-primary"><?php echo e($settings->currency); ?><?php echo e($amountToInvest ? number_format($amountToInvest) : '0'); ?></p>
                            </div>
                            
                            <!-- Investment Button -->
                            <div class="text-center">
                                <form action="" wire:submit.prevent="joinPlan">
                                    <button 
                                        class="w-full py-3 px-4 bg-primary hover:bg-primary/90 text-white rounded-lg transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary"
                                        <?php echo e($disabled); ?>

                                    >
                                        <div class="flex items-center justify-center">
                                            <i data-lucide="check-circle" class="h-5 w-5 mr-2"></i>
                                            Confirm & Invest
                                        </div>
                                    </button>
                                </form>
                                <p class="mt-2 text-sm text-primary" wire:loading wire:target="joinPlan">
                                    <?php echo e($feedback); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- No Plans Available Message -->
        <div class="dark:bg-dark-50 bg-white rounded-xl shadow-md overflow-hidden">
            <div class="p-6 text-center">
                <div class="flex items-center justify-center h-16 w-16 rounded-full bg-yellow-100 text-yellow-600 mx-auto mb-4">
                    <i data-lucide="alert-circle" class="h-8 w-8"></i>
                </div>
                <h3 class="text-lg font-medium dark:text-white text-dark mb-2">No Investment Plans Available</h3>
                <p class="dark:text-gray-400 text-gray-600">
                    No investment plans are available at the moment. Please contact our support for more information.
                </p>
                <button class="mt-4 inline-flex items-center px-4 py-2 bg-primary hover:bg-primary/90 text-white rounded-lg transition-colors duration-200">
                    <i data-lucide="message-circle" class="h-5 w-5 mr-2"></i>
                    Contact Support
                </button>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH /home7/ticketie/public_html/resources/views/livewire/user/investment-plan.blade.php ENDPATH**/ ?>