'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import randomstring from 'randomstring';
let TrackerEventListenerManager = class TrackerEventListenerManager {
    /**
   * Returns the dictionary of tracker event listeners
   * @returns {{[listenerId: string]: TrackerEventListener}} dictionary of tracker event listeners
   */ get trackerEventListeners() {
        return this._trackerEventListeners;
    }
    /**
   * Adds a tracker event listener
   * @param {TrackerEventListener} listener tracker event listener 
   * @param {String} [accountId] account id
   * @param {String} [trackerId] tracker id
   * @param {Number} [sequenceNumber] event sequence number
   * @returns {String} tracker event listener id
   */ addTrackerEventListener(listener, accountId, trackerId, sequenceNumber) {
        const listenerId = randomstring.generate(10);
        this._trackerEventListeners[listenerId] = listener;
        this._startTrackerEventJob(listenerId, listener, accountId, trackerId, sequenceNumber);
        return listenerId;
    }
    /**
   * Removes tracker event listener by id
   * @param {String} listenerId listener id 
   */ removeTrackerEventListener(listenerId) {
        delete this._trackerEventListeners[listenerId];
    }
    _startTrackerEventJob(listenerId, listener, accountId, trackerId, sequenceNumber) {
        var _this = this;
        return _async_to_generator(function*() {
            let throttleTime = _this._errorThrottleTime;
            while(_this._trackerEventListeners[listenerId]){
                try {
                    const packets = yield _this._domainClient.requestApi({
                        url: '/users/current/tracker-events/stream',
                        method: 'GET',
                        headers: {
                            'auth-token': _this._domainClient.token,
                            'api-version': '1'
                        },
                        params: {
                            previousSequenceNumber: sequenceNumber,
                            accountId,
                            trackerId,
                            limit: 1000
                        }
                    }, true);
                    for (let packet of packets){
                        yield listener.onTrackerEvent(packet);
                    }
                    throttleTime = _this._errorThrottleTime;
                    if (_this._trackerEventListeners[listenerId] && packets.length) {
                        sequenceNumber = packets.slice(-1)[0].sequenceNumber;
                    }
                } catch (err) {
                    listener.onError(err);
                    yield new Promise((res)=>setTimeout(res, throttleTime));
                    throttleTime = Math.min(throttleTime * 2, 30000);
                }
            }
        })();
    }
    /**
   * Constructs tracker event listener manager instance
   * @param {DomainClient} domainClient domain client
   */ constructor(domainClient){
        this._domainClient = domainClient;
        this._trackerEventListeners = {};
        this._errorThrottleTime = 1000;
    }
};
/**
 * Manager for handling tracking event listeners
 */ export { TrackerEventListenerManager as default };

//# sourceMappingURL=data:application/json;base64,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